/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.webservices;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.PathUtils;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.adaptors.webservices.WSInvokeOperation;
import filenet.vw.integrator.adaptors.webservices.WSReplyOperation;
import filenet.vw.integrator.adaptors.webservices.WSRequestOperation;
import filenet.vw.integrator.base.VWAdaptor;
import filenet.vw.integrator.base.VWResources;
import filenet.vw.server.VWCapsule;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.listener.axis.rm.WSRMCallback;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.listener.axis.rm.WSUUIDGenFactory;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.att.IWSAttSession;
import filenet.ws.utils.jsse.WSJSSE;
import java.net.BindException;
import org.apache.sandesha.SandeshaContext;
import org.apache.sandesha.client.ClientListener;
import org.apache.sandesha.server.Sender;
import org.apache.sandesha.server.SenderWorker;
import org.apache.sandesha.storage.Callback;
import org.apache.sandesha.util.PropertyLoader;
import org.apache.sandesha.ws.rm.providers.RMProvider;

public class VWWebServicesAdaptor
extends VWAdaptor {
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.WebServices");
    protected static final String g_className = "VWWebServicesAdaptor:";
    protected ClientListener rmClientListener = null;
    public static WSListenerProperties gWSListenerProperties = null;
    private static String[] WSRequestPollingPropertyNames = new String[]{"cm.ws.request.polling.interval", "cm.ws.request.max.polling.interval", "filenet.ws.request.concurrent.threads"};

    public static String _get_FILE_DATE() {
        return "$Date:   02 Oct 2008 10:25:16  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.46  $";
    }

    public static void STATIC_INITIALIZER(String connectionPoint) {
        try {
            gWSListenerProperties = WSListenerProperties.instance(new PathUtils(), connectionPoint);
            WSJSSE.installAxisJSSESocketFactory(gWSListenerProperties);
            WSRMCallback cb = WSRMCallback.getCallbackInstance();
            RMProvider.setCallback((Callback)cb);
            Sender.setCallback((Callback)cb);
            SenderWorker.setCallback((Callback)cb);
            WSUUIDGenFactory.getUUIDGen();
            WSRMUtils.setWSListenerProperties(gWSListenerProperties);
            WSWSRRRegistry.addIBMSecurityProviders();
        }
        catch (Exception ex) {
            logger.throwing(g_className, "static initializer", ex);
        }
    }

    public VWWebServicesAdaptor(VWQueue queue, String component_descriptor, int index) throws Exception {
        super(queue, component_descriptor, index);
        if (gWSListenerProperties == null) {
            VWWebServicesAdaptor.STATIC_INITIALIZER(queue.getServiceSession().getConnectionPointName());
        }
        this.m_className = g_className + this.m_id;
        if (gWSListenerProperties != null) {
            gWSListenerProperties.WSRMSandeshaSettings();
            if (logger.isFinest()) {
                logger.finest(this.m_className, "ctor", "finished setting WSRM stuff..");
            }
        }
        if (index == 1) {
            this.rmClientListener = new ClientListener(PropertyLoader.getClientSideListenerPort());
        }
    }

    public static boolean GetWSRequestValidateMessages() {
        boolean res = false;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("filenet.ws.request.validate.messages")) != null) {
                res = new Boolean(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static long GetPollingRate() {
        long res = 1000L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("cm.ws.request.polling.interval")) != null) {
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static long GetMaxPollingRate() {
        long res = 60000L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("cm.ws.request.max.polling.interval")) != null) {
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static long GetConcurentThreads() {
        long res = 1L;
        try {
            if (gWSListenerProperties != null) {
                String s = gWSListenerProperties.getProperty("filenet.ws.request.concurrent.threads");
                logger.finest("VWWebServicesAdaptor", "GetConcurrentThreads", s);
                if (s == null) {
                    s = System.getProperty("filenet.ws.num.threads", "1");
                }
                logger.finest("VWWebServicesAdaptor", "GetConcurrentThreads -- really", s);
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PersistComponentDescriptor(String component_descriptor) {
        block8: {
            try {
                String concurrentThreads;
                String maxpr;
                if (gWSListenerProperties == null) break block8;
                VWXMLWrapper cdoc = new VWXMLWrapper(component_descriptor);
                String pr = VWXMLWrapper.getNodeValue(cdoc.getRootNode(), "polling_rate");
                if (pr == null) {
                    pr = "1000";
                }
                if ((maxpr = VWXMLWrapper.getNodeValue(cdoc.getRootNode(), "max_polling_rate")) == null) {
                    maxpr = "60000";
                }
                if ((concurrentThreads = VWXMLWrapper.getNodeValue(cdoc.getRootNode(), "concurrent_threads")) == null) {
                    concurrentThreads = "1";
                }
                WSListenerProperties wSListenerProperties = gWSListenerProperties;
                synchronized (wSListenerProperties) {
                    gWSListenerProperties.setProperties(WSRequestPollingPropertyNames, new String[]{pr, maxpr, concurrentThreads}, true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static int GetWsTimeout() {
        int res = 300000;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("synchronous.timeout")) != null) {
                res = Integer.parseInt(s) * 1000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static long GetWSRequestCacheTimeout() {
        long res = 4L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("filenet.ws.request.cache.timeout")) != null) {
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res * 60L * 60L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWSAttSession getWSSession(String username, String password) {
        String m_method = "getWSSession:" + username;
        logger.entering(this.m_className, m_method);
        try {
            String handlerClassName = null;
            if (gWSListenerProperties != null) {
                handlerClassName = gWSListenerProperties.getProperty("att.handler");
            }
            if (handlerClassName == null) {
                handlerClassName = "filenet.vw.idm.trident.WSSession";
            }
            Class<?> handlerClass = Class.forName(handlerClassName);
            IWSAttSession res = (IWSAttSession)handlerClass.newInstance();
            res.setCredentials(username, password);
            IWSAttSession iWSAttSession = res;
            return iWSAttSession;
        }
        catch (Throwable t) {
            IWSAttSession iWSAttSession = null;
            return iWSAttSession;
        }
        finally {
            logger.exiting(this.m_className, m_method);
        }
    }

    private static String GetMyListenerURL() {
        String m_method = "getMyListenerURL";
        String res = null;
        try {
            if (gWSListenerProperties != null) {
                res = gWSListenerProperties.getProperty("listener.base.url");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(g_className, "getMyListenerURL", res);
        }
        return res;
    }

    private static String GetTraceFile() {
        String m_method = "GetTraceFile";
        String res = null;
        try {
            if (gWSListenerProperties != null) {
                res = gWSListenerProperties.getProperty("filenet.ws.request.tracefile");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(g_className, "GetTraceFile", res);
        }
        return res;
    }

    private static long GetTraceFileSize() {
        long res = 5000000L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("filenet.ws.request.tracefilesize")) != null) {
                try {
                    res = Long.parseLong(s);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private static boolean GetTraceOption() {
        String m_method = "getTraceOption";
        boolean res = false;
        try {
            if (gWSListenerProperties != null) {
                res = new Boolean(gWSListenerProperties.getProperty("filenet.ws.request.tracing", "true"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(g_className, "getTraceOption", new Boolean(res).toString());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String m_method = "run";
        logger.entering(this.m_className, "run");
        String filter = "(F_OperationId = 39 or F_OperationId = 41) and F_WsStatus = 0";
        try {
            long polling_rate;
            this.m_status = VWResources.VWS_ADAPTOR_RUN_STARTING.toString(this.m_id, this.getLocaleDateStringNow());
            long initial_polling_rate = polling_rate = VWWebServicesAdaptor.GetPollingRate();
            this.done = false;
            this.startTime = System.currentTimeMillis();
            this.callTime = 0.0;
            this.callCount = 0.0;
            if (this.component_descriptor_doc == null) {
                throw new VWException("vw.integrator.base.NoComponentDescriptor", "Unable to obtain valid component descriptor for {0}.", this.m_id);
            }
            String username = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_username");
            String password = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_password");
            VWCapsule capsule = new VWCapsule();
            capsule.setString(password);
            password = capsule.getString();
            String routerurl = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "routerurl");
            if (this.m_index == 1 && this.rmClientListener != null) {
                try {
                    this.rmClientListener.start();
                    SandeshaContext.init((boolean)true);
                }
                catch (BindException e) {
                    VWException ex = new VWException("vw.integrator.base.FailedStartRMClientListener", "Failed to establish connection to the Reliable Messaging client listener port {0}: {1}.", Integer.toString(PropertyLoader.getClientSideListenerPort()), e.getMessage());
                    ex.setCause(e);
                    throw ex;
                }
                catch (Exception e) {
                    VWException ex = new VWException("vw.integrator.base.FailedToInitalizedSandesha", "Failed to initialized Sandesha for Reliable Messaging: {0}.", e.getMessage());
                    ex.setCause(e);
                    throw ex;
                }
            }
            VWSession session = null;
            IWSAttSession wsSession = null;
            VWQueueQuery queue_query = null;
            while (!this.done) {
                try {
                    session = new VWSession(username, password, routerurl);
                    VWQueue queue = session.getQueue(this.m_queueName);
                    queue.setBufferSize(1);
                    initial_polling_rate = polling_rate = VWWebServicesAdaptor.GetPollingRate();
                    int wsTimeout = VWWebServicesAdaptor.GetWsTimeout();
                    long max_polling_rate = VWWebServicesAdaptor.GetMaxPollingRate();
                    int polling_increment = 15000;
                    String pollingIncr = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "polling_increment");
                    if (pollingIncr != null) {
                        try {
                            polling_increment = Integer.parseInt(pollingIncr);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    while (!this.done) {
                        while (!this.done) {
                            queue_query = null;
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, "run", "New loop, filter=(F_OperationId = 39 or F_OperationId = 41) and F_WsStatus = 0");
                            }
                            if ((queue_query = queue.createQuery(null, null, null, 16, "(F_OperationId = 39 or F_OperationId = 41) and F_WsStatus = 0", null, 5)).hasNext()) {
                                polling_rate = initial_polling_rate;
                                if (!logger.isFinest()) break;
                                logger.finest(this.m_className, "run", "Got work!");
                                break;
                            }
                            if (initial_polling_rate != 0L) {
                                polling_rate = polling_rate < max_polling_rate ? (polling_rate += (long)polling_increment) : max_polling_rate;
                            }
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, "run", "end of list, next polling_rate=" + Long.toString(polling_rate) + "ms");
                            }
                            this.m_status = VWResources.VWS_ADAPTOR_RUN_WAITING.toString(new Object[]{this.m_id, new Long(polling_rate), this.getLocaleDateStringNow()});
                            VWWebServicesAdaptor ex = this;
                            synchronized (ex) {
                                this.wait(polling_rate);
                            }
                        }
                        if (this.done || queue_query == null) continue;
                        while (queue_query.hasNext()) {
                            try {
                                long tempCallTime = System.currentTimeMillis();
                                VWStepElement se = (VWStepElement)queue_query.next();
                                String opName = se.getOperationName();
                                String wobId = se.getWorkObjectNumber();
                                String workflowName = se.getWorkflowName();
                                String tId = new StringBuffer(opName).append(" wobNum=").append(wobId).append(", workflowName=").append(workflowName).toString();
                                this.m_status = VWResources.VWS_WSADAPTOR_RUN_PROCESSINGSE.toString(new Object[]{this.m_id, opName, wobId, workflowName, this.getLocaleDateStringNow()});
                                if (logger.isFinest()) {
                                    logger.finest(this.m_className, "run", this.m_status);
                                }
                                gWSListenerProperties.WSRMSandeshaSettings();
                                if (wsSession == null) {
                                    wsSession = this.getWSSession(username, password);
                                }
                                try {
                                    WSRequestOperation wsOp;
                                    String opStatus = "UNKNOWN";
                                    if (opName.equals("Invoke")) {
                                        wsOp = new WSInvokeOperation(session, wsSession, wsTimeout, VWWebServicesAdaptor.GetTraceOption(), VWWebServicesAdaptor.GetTraceFile(), VWWebServicesAdaptor.GetTraceFileSize(), VWWebServicesAdaptor.GetWSRequestCacheTimeout(), VWWebServicesAdaptor.GetMyListenerURL(), VWWebServicesAdaptor.GetWSRequestValidateMessages(), this.m_index, username, password);
                                        opStatus = ((WSInvokeOperation)wsOp).invoke(se);
                                    } else {
                                        wsOp = new WSReplyOperation(session, wsSession, wsTimeout, VWWebServicesAdaptor.GetTraceOption(), VWWebServicesAdaptor.GetTraceFile(), VWWebServicesAdaptor.GetTraceFileSize(), VWWebServicesAdaptor.GetWSRequestCacheTimeout(), VWWebServicesAdaptor.GetWSRequestValidateMessages(), this.m_index);
                                        opStatus = ((WSReplyOperation)wsOp).reply(se);
                                    }
                                    this.m_status = VWResources.VWS_WSADAPTOR_RUN_PROCESSINGSEOK.toString(new Object[]{this.m_id, opName, wobId, workflowName, opStatus, this.getLocaleDateStringNow()});
                                    logger.info(this.m_className, "run", this.m_status);
                                }
                                catch (Exception e) {
                                    this.m_status = VWResources.VWS_WSADAPTOR_RUN_PROCESSINGSE_EX.toString(new Object[]{this.m_id, opName, wobId, workflowName, this.getLocaleDateStringNow(), VWException.DescribeThrowableAndItsCause(e)});
                                    logger.severe(this.m_className, "run", this.m_status);
                                }
                                Object object = this.statsSyncObj;
                                synchronized (object) {
                                    this.callTime += (double)(System.currentTimeMillis() - tempCallTime);
                                    this.callCount += 1.0;
                                }
                            }
                            catch (Exception e) {
                                logger.throwing(this.m_className, "run", e);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    logger.throwing("filenet.vw.integrator.base.VWAdaptor", "run", t);
                }
                if (this.done) continue;
                this.m_status = VWResources.VWS_ADAPTOR_RUN_WAITING.toString(new Object[]{this.m_id, new Long(polling_rate), this.getLocaleDateStringNow()});
                VWWebServicesAdaptor t = this;
                synchronized (t) {
                    this.wait(polling_rate);
                }
            }
            if (this.rmClientListener != null) {
                this.rmClientListener.stop();
            }
            WSRequestOperation.ClearWSDLCache();
            if (logger.isFinest()) {
                logger.finest(this.m_className, "run", "time to get out..");
            }
            if (queue_query != null) {
                try {
                    while (queue_query.hasNext()) {
                        VWStepElement se = (VWStepElement)queue_query.next();
                        se.doAbort();
                    }
                }
                catch (Exception qe) {
                    // empty catch block
                }
            }
            if (session != null) {
                try {
                    session.logoff();
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            if (wsSession != null) {
                try {
                    wsSession.close();
                }
                catch (Exception wse) {
                    // empty catch block
                }
            }
            if (logger.isFinest()) {
                logger.finer(this.m_className, "run", Thread.currentThread() + " - has shut down.");
            }
        }
        catch (Exception e) {
            String s;
            String cause = VWException.DescribeThrowableAndItsCause(e);
            this.m_status = s = VWResources.VWS_ADAPTOR_RUN_STOPPED_WITH_EX.toString(new Object[]{this.m_id, cause, this.m_status});
            logger.throwing(this.m_className, "run", e);
            logger.severe(this.m_className, "run", s);
        }
        this.done = true;
        logger.exiting(this.m_className, "run");
    }
}

